import MediaSelect from './media-select'
import ButtonRender from './button-render'
const { PanelBody, SelectControl, RadioControl } = wp.components;
const { InspectorControls, PanelColorSettings } = wp.blockEditor;
const { useEffect, useRef, useState, Fragment } = wp.element;
const { withSelect } = wp.data;
const { __ } = wp.i18n; // Import __() from wp.i18n
const { njtwa } = window

const InputControl = wp.components.__experimentalInputControl

const edit = ({
	attributes,
	setAttributes,
	className,
	isSelected,
	postList
}) => {
	const textareaInfo = useRef(null)
	const [state, setState] = useState({
		buttonName: "",
		metaInfo: {},
		metaStyle: {}
	});
	const [loading, setLoading] = useState(false)
	useEffect(() => {
		if (attributes.isSelectedAccount != -1) {
			setLoading(true)
			jQuery.ajax({
				url: ajaxurl,
				type: 'POST',
				data: {
					'action': 'njt_wa_get_account',
					'id': attributes.isSelectedAccount,
					'nonce': njtwa.nonce
				}
			}).done(function(result) {
				setLoading(false)
				setState({...result})
			});
		}
	}, [attributes.isSelectedAccount]);

	useEffect(() => {
		if (textareaInfo.current) {
			textareaInfo.current.style.height = textareaInfo.current.scrollHeight + 'px'
		}
	}, [textareaInfo])

	const colorSamples = [
		{
			name: 'Coral',
			slug: 'coral',
			color: '#cd2653'
		},
		{
			name: 'Lavender',
			slug: 'lavender',
			color: '#000000'
		},
		{
			name: 'White',
			slug: 'white',
			color: '#6d6d6d'
		},
		{
			name: 'White',
			slug: 'white',
			color: '#dcd7ca'
		},
		{
			name: 'White',
			slug: 'white',
			color: '#f5efe0'
		}
	];
	const buttonTypeClass = attributes.buttonStyle == "round" ? "wa__r_button" : "wa__sq_button";
	const avatarClass = attributes.imageUrl ? "wa__btn_w_img" : "wa__btn_w_icon";
	const avatarStyle = {
		backgroundImage: `url(${attributes.imageUrl})`,
		backgroundSize: 'cover',
		backgroundPosition: 'center center',
		backgroundRepeat : 'no-repeat'
	}

	const avatarOrIconContent = attributes.imageUrl ? (
		<div className="wa__cs_img">
			<div 
				className="wa__cs_img_wrap"
				style={avatarStyle} 
			/>
		</div>
	) : (
		<div className="wa__btn_icon">
			<img alt="img" src={njtwa.avatarDefaultUrl}/>
		</div>
	);

	const inputStyle = {
		color: ( !attributes.textColor || attributes.textColor == '#fff' || attributes.textColor == '#ffffff') ? '#d5f0d9' : attributes.textColor,
		background: 'transparent',
		border: 'none',
		outline: 'none',
		opacity: ( !attributes.textColor || attributes.textColor == '#fff' || attributes.textColor == '#ffffff') ? 0.8 : 1
	} 
	
	const titleContent = attributes.buttonTitle ? (
		<div className="wa__cs_info">
			<div
				className="wa__cs_name"
				style={{color: attributes.textColor}}
			>
				{/* {attributes.buttonTitle} */}
				<input
					style={inputStyle} 
					onChange={(event) => setAttributes( {buttonTitle: event.target.value} )}
					value={attributes.buttonTitle}
				/>
			</div>
			{/* <div 
				className="wa__cs_status"
			>
				{__("Online", "ninjateam-whatsapp")}
			</div> */}
		</div>
	) : null;

	const titleClass = attributes.buttonTitle ? '' : 'wa__button_text_only'
	
	const accountList = () => {
		let list = [{label: __('Custom Button', 'ninjateam-whatsapp'), value: -1}]
		if ( postList ) {
			const postListOptions = postList.map((post) => ({label: post.title.raw, value: post.id}))
			list = [...list, ...postListOptions]
		}
		return list 
	}
	const textareaStyle = {
		background: 'transparent',
		border: 'none',
		color: attributes.textColor ? attributes.textColor : '#fff',
		outline: 'none',
		resize: 'none',
		overflow: 'hidden',
		padding: 0,
		boxShadow: 'none'
	}

	const inspectControl = (
		<InspectorControls>
			<PanelBody title={__("Select Account", "ninjateam-whatsapp")}>
				<SelectControl
					label={__("Choose your account from list:", "ninjateam-whatsapp")}
					value={ attributes.isSelectedAccount }
					options={accountList()}
					onChange={(postId) => setAttributes({isSelectedAccount: postId})}
				/>
				{ attributes.isSelectedAccount == '-1' ?
					(<Fragment>
						<InputControl
							label={__("Enter your phone number:", "ninjateam-whatsapp")}
							value={ attributes.phoneNumber }
							onChange={ ( phoneNumber ) => setAttributes( {phoneNumber} ) }
						/>
						{/* <InputControl
							label={__("Title:", "ninjateam-whatsapp")}
							value={ attributes.buttonTitle }
							onChange={ ( buttonTitle ) => setAttributes( {buttonTitle} ) }
						/>
						<InputControl
							label={__("Label:", "ninjateam-whatsapp")}
							value={ attributes.buttonInfo }
							onChange={ ( buttonInfo ) => setAttributes( {buttonInfo} ) }
						/> */}
					</Fragment>)
					: null
				}
				
			</PanelBody>
			{ 	attributes.isSelectedAccount == -1 ?
				(<Fragment>
					<PanelBody initialOpen={false} title={__("Avatar", "ninjateam-whatsapp")}>
						<MediaSelect 
							attributes={attributes}
							setAttributes={setAttributes}
							/>
						</PanelBody>

						<PanelBody initialOpen={false} title={__("Button Style", "ninjateam-whatsapp")}>
							<RadioControl
								label="Button Shape"
								selected={ attributes.buttonStyle }
								options={ [
									{ label: __("Round", "ninjateam-whatsapp"), value: 'round' },
										{ label: __("Square", "ninjateam-whatsapp"), value: 'square' },
									] }
								onChange={ ( buttonStyle ) => { setAttributes( {buttonStyle} )  } }
								/>
							</PanelBody>
								
							<PanelColorSettings
								initialOpen={false}
								title={__("Button Color", "ninjateam-whatsapp")}
								colorSettings={[
									{
										colors: colorSamples,
										value: attributes.buttonColor,
										label: __("Background Color", "ninjateam-whatsapp"),
										onChange: (buttonColor) => setAttributes({buttonColor})
									},
									{
										colors: colorSamples,
										value: attributes.textColor,
										label: __("Text Color", "ninjateam-whatsapp"),
										onChange: (textColor) => setAttributes({textColor})
									}
								]}
							/>
				</Fragment>) : null
			}
			
		</InspectorControls>
	);
	return (
		<Fragment>
			{	attributes.preview ? <div style={{padding: '10px'}}><img src={njtwa.gutenbergPreview} alt="preview" /></div> :
				( 
					attributes.isSelectedAccount != -1 ? 
					<ButtonRender attributes={state} loading={loading}/>
					:
					<div>
						<a
							href="#"
							className={`wa__button wa__stt_online ${buttonTypeClass} ${avatarClass} ${titleClass}`}
							style={{backgroundColor: attributes.buttonColor, color: attributes.textColor}}
						>
							{avatarOrIconContent}
							<div className="wa__btn_txt">
								{titleContent}
								<div className="wa__btn_title">
									<textarea
										rows={1}
										ref={textareaInfo}
										style={textareaStyle}
										onChange={(event) => {
											event.target.style.height = '15px'
											event.target.style.height = event.target.scrollHeight + 'px'
											setAttributes( {buttonInfo: event.target.value} )
										} }  
										value={attributes.buttonInfo}
									/>
									{/* {attributes.buttonInfo} */}
								</div>
							</div>
						</a>
					</div>
				)
			}
		{inspectControl}
		</Fragment>
	);
};

export default withSelect((select, ownProps) => {
	return {
		postList: select("core").getEntityRecords("postType", "whatsapp-accounts", { per_page: -1 })
	};
})(edit);
